/***********************************************************************
 *
 * Copyright (c) 2002 PalmSource, Inc. or its subsidiaries.
 * All rights reserved.
 *
 ***********************************************************************
 *
 * FILE: SMSCodec.h
 *
 *
 * DESCRIPTION:
 *
 *
 * AUTHOR:
 *	October	10, 2002	Created by Yann Cheri (YCh)
 *	mmmm dd, yyyy	Now owned by .....
 *
 ***********************************************************************/
#ifndef SMSCODEC_H
#define SMSCODEC_H

#include "SHTarget.h"
#include "CharSetString.h"
#include "SMSCodecDefines.h"

//
#define	kSMSCodecDecodePDU				0
#define	kSMSCodecEncodePDU				1
//
#define	kSMSCodecDirSCToMS				0
#define	kSMSCodecDirMSToSC				1
//
#define kSMSErrNone						0
#define kSMSErrTypeNotSupported			1
#define kSMSErrInvalidInfoElement		2
#define kSMSErrInvalidAlphabet			3
#define kSMSErrInvalidValidityPeriod	4
#define kSMSErrInvalidProtocolId		5
#define kSMSErrInvalidDCSType			6
#define kSMSErrLast						20

#define SemiOctet(byte) (((byte) & 0x0F )*10) + (((byte) >> 4))
/////////////////////////////////////////////////////////////////////////////
// TP Tags		//
enum kSMSTPTag
{
	kSMSTPTag_TP_MTI = 0,
	kSMSTPTag_TP_MMS,
	kSMSTPTag_TP_VPF,
	kSMSTPTag_TP_SRI,
	kSMSTPTag_TP_SRR,
	kSMSTPTag_TP_MR,
	kSMSTPTag_TP_OA,
	kSMSTPTag_TP_DA,
	kSMSTPTag_TP_PID,
	kSMSTPTag_TP_DCS,
	kSMSTPTag_TP_SCTS,	// 10
	kSMSTPTag_TP_VP,
	kSMSTPTag_TP_DT,
	kSMSTPTag_TP_RA,
	kSMSTPTag_TP_ST,
	kSMSTPTag_TP_UDL,
	kSMSTPTag_TP_RP,
	kSMSTPTag_TP_MN,
	kSMSTPTag_TP_CT,
	kSMSTPTag_TP_CDL,
	kSMSTPTag_TP_CD,	// 20
	kSMSTPTag_TP_FCS,
	kSMSTPTag_TP_UDHI,
	kSMSTPTag_TP_UD,
	kSMSTPTag_TP_RD,
	kSMSTPTag_TP_SRQ,
	kSMSTPTag_TP_PI		// 26
};
/////////////////////////////////////////////////////////////////////////////
// TP Tags		//
enum kSMSTPTagExt
{
	kSMSTP_Dir = (kSMSTPTag)kSMSTPTag_TP_PI + 1,	// 27
	kSMSTP_AF_TON,
	kSMSTP_AF_NPI,
	kSMSTP_AF_Address,	// 30
	kSMSTP_DCS_CG,
	kSMSTP_DCS_C,
	kSMSTP_DCS_MCM,
	kSMSTP_DCS_MCl,
	kSMSTP_DCS_MCo,
	kSMSTP_DCS_A,
	kSMSTP_DCS_I,
	kSMSTP_DCS_IT,
	kSMSTP_PID_T,
	kSMSTP_PID_TI,		// 40
	kSMSTP_PID_TIT,
	kSMSTP_PID_SMT,
	kSMSTP_PID_V,
	kSMSTP_VP_V,
	kSMSTP_VP_E_EB,
	kSMSTP_VP_E_SS,
	kSMSTP_VP_E_F,
	kSMSTP_VP_Y,
	kSMSTP_VP_Mo,
	kSMSTP_VP_D,		// 50
	kSMSTP_VP_H,
	kSMSTP_VP_Mi,
	kSMSTP_VP_S,
	kSMSTP_VP_TZ,
	kSMSTP_DT_Y,
	kSMSTP_DT_Mo,
	kSMSTP_DT_D,
	kSMSTP_DT_H,
	kSMSTP_DT_Mi,
	kSMSTP_DT_S,		// 60
	kSMSTP_DT_TZ,
	kSMSTP_SCTS_Y,
	kSMSTP_SCTS_Mo,
	kSMSTP_SCTS_D,
	kSMSTP_SCTS_H,
	kSMSTP_SCTS_Mi,
	kSMSTP_SCTS_S,
	kSMSTP_SCTS_TZ,
	kSMSTP_PI_PID,
	kSMSTP_PI_DCS,		// 70
	kSMSTP_PI_UDL,
	// UD
	kSMSTP_UDHL,
	kSMSTP_UD_C8,
	kSMSTP_UD_C16,
	kSMSTP_UD_Cx_R,
	kSMSTP_UD_Cx_M,
	kSMSTP_UD_Cx_S,
	kSMSTP_UD_S,
	kSMSTP_UD_S_V,
	kSMSTP_UD_S_V_S,	// 80
	kSMSTP_UD_S_V_C,
	kSMSTP_UD_S_F,
	kSMSTP_UD_S_F_S,
	kSMSTP_UD_S_F_C,
	kSMSTP_UD_S_E,
	kSMSTP_UD_S_E_S,
	kSMSTP_UD_S_E_C,
	kSMSTP_UD_S_O,
	kSMSTP_UD_S_O_S,
	kSMSTP_UD_S_O_C,	// 90
	kSMSTP_UD_AP8,
	kSMSTP_UD_AP16,
	kSMSTP_UD_APx_D,
	kSMSTP_UD_APx_O,
	kSMSTP_UD_SMSC,
	kSMSTP_UD_SMSC_SP,
	kSMSTP_UD_SMSC_STA,
	kSMSTP_UD_SMSC_STT,
	kSMSTP_UD_SMSC_SCo,
	kSMSTP_UD_SMSC_SCa,	// 100
	kSMSTP_UD_SMSC_SI,
	kSMSTP_UD_UDH,
	kSMSTP_UD_UDH_S,
	kSMSTP_UD_WCMP,
	kSMSTP_UD_WCMP_PDU,
	kSMSTP_UD_STKH,
	kSMSTP_UD_SME,
	kSMSTP_UD_SCSp,
	kSMSTP_UD_Data,
	kSMSTP_LastTag	// End Tag	// 110
};
/////////////////////////////////////////////////////////////////////////////
// SMS Time
enum kSMSTime
{
	kSMSTime_Year = 0,
	kSMSTime_Month,
	kSMSTime_Day,
	kSMSTime_Hour,
	kSMSTime_Minute,
	kSMSTime_Second,
	kSMSTime_TimeZone,
	kSMSTime_Count
};
/////////////////////////////////////////////////////////////////////////////
// SMS Types //
enum kSMSType
{
	kSMSType_Deliver = 0,
	kSMSType_DeliverReportError,
	kSMSType_DeliverReportAck,
	kSMSType_Submit,
	kSMSType_SubmitReportError,
	kSMSType_SubmitReportAck,
	kSMSType_StatusReport,
	kSMSType_Command
};
typedef unsigned short Tag;
/////////////////////////////////////////////////////////////////////////////
// SMS Address Field Class
class CSMSAddressField
{
public:
	Tag len, ton, npi;
	UInt8  *valueP;
public:
	CSMSAddressField() {len = 0; ton = (Tag)-1; npi= (Tag)-1; valueP = NULL;};
	~CSMSAddressField() {if(valueP)	{delete(valueP); valueP = NULL;}};
};
/////////////////////////////////////////////////////////////////////////////
// SMS Enhanced Validity Period
class CSMSEnhancedValidityPeriod
{
public:
	Tag extensionBit, singleShot, format;
public:
	CSMSEnhancedValidityPeriod()
		{
		extensionBit = 0; singleShot = 0; format = 0;
		};
};

// SMS Validity Period
class CSMSValidityPeriod
{
public:
	Tag absolute[7];
	Tag relative;
	CSMSEnhancedValidityPeriod enhanced;
public:
	CSMSValidityPeriod()
		{
		for(int i=0; i<kSMSTime_Count; i++)
			absolute[i] = 0; //-1;

		relative = 0;
		};
};
/////////////////////////////////////////////////////////////////////////////
// SMS Data Coding Scheme
class CSMSDataCodingScheme
{
public:
	Tag codingGroup, compressed, msgClassPresent, msgClass, msgCoding, alphabet, indication, indicationType;
public:	
	CSMSDataCodingScheme()
		{
		codingGroup = (Tag)-1;	compressed = (Tag)-1;		msgClassPresent = (Tag)-1;
		msgClass = (Tag)-1;		msgCoding =  (Tag)-1;		alphabet = (Tag)-1;
		indication = (Tag)-1;	indicationType = (Tag)-1;
		};
};
/////////////////////////////////////////////////////////////////////////////
// SMS Protocol Identifier
class CSMSProtocolIdentifier
{
public:
	Tag type, teleInterw, teleInterwType, smType, value;
public:
	CSMSProtocolIdentifier()
		{
		type = (Tag)-1;	teleInterw = (Tag)-1;	teleInterwType = (Tag)-1;	smType = (Tag)-1; value = (Tag)-1;
		};
};
/////////////////////////////////////////////////////////////////////////////
// SMS Protocol Identifier
class CSMSParameterIndicator
{
public:
	Tag udl, dcs, pid;
public:	
	CSMSParameterIndicator()
		{
		udl = (Tag)-1; dcs = (Tag)-1; pid = (Tag)-1;
		};
};
/////////////////////////////////////////////////////////////////////////////
// SMS Types //
enum kSMSInfoElementType
{
	kSMSIEType_Concat8BRef = 0,
	kSMSIEType_SpecialVoice,
	kSMSIEType_SpecialFax,
	kSMSIEType_SpecialEMail,
	kSMSIEType_SpecialOther,
	kSMSIEType_Reserved1,
	kSMSIEType_NotUsed,
	kSMSIEType_AppPort8B,
	kSMSIEType_AppPort16B,
	kSMSIEType_SMSCControl,
	kSMSIEType_UDHSourceInd,
	kSMSIEType_Concat16BRef,
	kSMSIEType_WirelessCont,
	kSMSIEType_Reserved2,
	kSMSIEType_STKSecurity,
	kSMSIEType_SMEtoSMESpec,
	kSMSIEType_Reserved3,
	kSMSIEType_SCSpec,
	kSMSIEType_Reserved4,
	kSMSIEType_Last,
};
/////////////////////////////////////////////////////////////////////////////
// SMS User Data Element
class CSMSInfoElement
{
public:
	UInt8  active, id, len, *dataP;
public:
	CSMSInfoElement()
		{
		active = false; id = (UInt8)-1; len = (UInt8)-1; dataP = NULL;
		}
	
	~CSMSInfoElement()
		{
		if(dataP) {	delete(dataP); dataP = NULL;}
		}
};
/////////////////////////////////////////////////////////////////////////////
// SMS User Data Header
class CSMSUserDataHeader
{
public:
	UInt8 len;
	CSMSInfoElement* elementP;

	CSMSUserDataHeader();
	~CSMSUserDataHeader();
	
	void  Init();
	UInt8 GetInfoElementIdFromIndex(UInt8 iIndex, UInt8 *ioSpecialP); 
	UInt8 GetInfoElementIndexFromId(UInt8 iId);

};
/////////////////////////////////////////////////////////////////////////////
// SMS Params Class
class CSMSParams
{
public:
	Tag tp_UDHI;					// 1 bit, used by all types
	Tag tp_SRx;						// 1 bit, applies to TP_SRQ, TP_SRR and TP_SRI (Command, StatusReport, Submit and Deliver)
	Tag tp_MMS;						// 1 bit, used by Deliver and StatusReport only
	Tag tp_RP;						// 1 bit, used by Deliver and Submit only
	Tag tp_RD;						// 1 bit, used by Submit only
	Tag tp_MTI;						// 2 bits, used by all types
	Tag tp_ST;						// 1 Byte, used by StatusReport only
	Tag tp_MN;						// 1 Byte, used by Command only
	Tag tp_CT;						// 1 Byte, used by Command only
	Tag tp_VPF;						// 2 bits, only used by Submit
	Tag tp_FCS;						// 1 Integer, applies to DeliverReportError and SubmitReportError	
	Tag tp_MR;						// 1 Integer, used by Submit, StatusReport and Command only
	Tag tp_xDL;						// 1 Integer
	Tag tp_SCTS[kSMSTime_Count];	// 7 Bytes, applies to: Deliver, StatusReport, SubmitReportAck, SubmitReportError
	Tag tp_DT[kSMSTime_Count];		// 7 Bytes, used by StatusReport only
	CSMSParameterIndicator	tp_PI;	// 1 Byte, used by all reports
	CSMSProtocolIdentifier	tp_PID;	// 1 Byte, used by all types
	CSMSDataCodingScheme	tp_DCS;	// 1 Byte, used by all types except Command
	CSMSValidityPeriod		tp_VP;	// Undefined Size, depends on tp_VP. Only used by Submit
	CSMSAddressField		tp_xA;	// Undefined Size
									// NB: tp_xA applies to TP_OA, TP_RA and TP_DA (Deliver, Submit, StatusReport and Command)
	CSMSAddressField		tp_SMSC;// Undefined Size
	CSMSUserDataHeader		tp_UDH;	// User data header
	CCharSetString			tp_xD;	// Undefined Size, depends on tp_xDL
									// NB: tp_xDL and tp_xD apply to TP_UDL and TP_UD
									// as well as TP_CDL and TP_CD
	// Internal data
	kSMSType		smsType;		// Internal SMS Type Id
	Tag				smsDirection;	// SMS Direction
	Bool			smsCenterInMS;	// SMSC present
	int				smsPartRef;		// SMS Part reference number
	int				smsPartMax;		// SMS Part count
	int				smsPartSeq;		// SMS Part sequence

public:
	CSMSParams()
		{
		tp_UDHI= (Tag)-1;	tp_SRx = (Tag)-1;	tp_MMS = (Tag)-1;	tp_RP  = (Tag)-1;	tp_RD  = (Tag)-1; 
		tp_MTI = (Tag)-1;	tp_ST  = (Tag)-1; 	tp_MN  = (Tag)-1;	tp_CT  = (Tag)-1;	tp_VPF = (Tag)-1;
		tp_FCS = (Tag)-1; 	tp_MR  = (Tag)-1; 	tp_xDL = (Tag)-1;
		for(int i=0; i<kSMSTime_Count; i++)
			{
			tp_SCTS[i] = -1;	tp_DT[i] = -1;
			}
		};
	~CSMSParams()	{};
	CSMSParams(CSMSParams* iParam)
		{
		tp_UDHI= (Tag)-1;	tp_SRx = (Tag)-1;	tp_MMS = (Tag)-1;	tp_RP  = (Tag)-1;	tp_RD  = (Tag)-1; 
		tp_MTI = (Tag)-1;	tp_ST  = (Tag)-1; 	tp_MN  = (Tag)-1;	tp_CT  = (Tag)-1;	tp_VPF = (Tag)-1;
		tp_FCS = (Tag)-1; 	tp_MR  = (Tag)-1; 	tp_xDL = (Tag)-1;
		for(int i=0; i<kSMSTime_Count; i++)
			{
			tp_SCTS[i] = -1;	tp_DT[i] = -1;
			}

		}
};
/////////////////////////////////////////////////////////////////////////////
// SMS Params Class
class CSMSCodecParams
{
public:
	int			val, offset, size, mask, coding, curErr, dcs;
	
	Bool		partDetected;
	int			partDataSize;
	int			partHeaderType;
	UInt32		partOffset;

	CString		*pduBufP, outputText;
	CSMSParams	*paramsP;
public:
	CSMSCodecParams()	{
						partDetected = partOffset = partDataSize = 0;
						val = offset = size = mask = coding = curErr = 0;
						dcs = -1;
						};
	~CSMSCodecParams() {};
};
/////////////////////////////////////////////////////////////////////////////
// SMS MultiParts Struct
class CSMSPDU
{
public:
	CSMSPDU()		{ prevP=nextP=NULL; smsPartRef=smsPartMax=smsPartSeq=0;};
	~CSMSPDU()		{ if(nextP) {delete nextP; nextP=NULL;} };
public:
	int				smsPartRef;		// SMS Part reference number
	int				smsPartMax;		// SMS Part count
	int				smsPartSeq;		// SMS Part sequence
	int				smsDirection;	// SMS Part sequence
	CCharSetString	pdu;
	CSMSPDU*		nextP;
	CSMSPDU*		prevP;
};
/////////////////////////////////////////////////////////////////////////////
// TP Structure	//
typedef struct{
	kSMSTPTag	id;
	Int32		(*funcP)(CSMSCodecParams*);
	int			mask;
	Int32		size;
}SMS_TP_Type, *SMS_TP_Ptr;
/////////////////////////////////////////////
typedef struct{
	int			tagValue;
	const char*	nameP;
}SMS_TagText_Type, *SMS_TagText_Ptr;
/////////////////////////////////////////////
typedef struct{
	kSMSTPTag			id;
	const char*			nameP;
	int					itemsNumber;
	SMS_TagText_Type*	itemsP;
}SMS_TPText_Type, *SMS_TPText_Ptr;
/////////////////////////////////////////////
typedef struct{
	kSMSTPTagExt		id;
	const char*			nameP;
	int					itemsNumber;
	SMS_TagText_Type*	itemsP;
}SMS_TPExtText_Type, *SMS_TPExtText_Ptr;
/////////////////////////////////////////////////////////////////////////////
// SMS Type Structure //
typedef struct{
	kSMSType	id;
	int			*tagList;
	int			tagListSize;
}SMS_T_Type, *SMS_T_Ptr;
/////////////////////////////////////////////////////////////////////////////
class CSMSCodec
{
private:
	// Tag List according to the SMS type
	static int smsDeliverTagList[];					static int smsDeliverTagListSize;
	static int smsDeliverReportErrorTagList[];		static int smsDeliverReportErrorTagListSize;
	static int smsDeliverReportAckTagList[];		static int smsDeliverReportAckTagListSize;
	static int smsSubmitTagList[];					static int smsSubmitTagListSize;
	static int smsSubmitReportErrorTagList[];		static int smsSubmitReportErrorTagListSize;
	static int smsSubmitReportAckTagList[];			static int smsSubmitReportAckTagListSize;
	static int smsStatusReportTagList[];			static int smsStatusReportTagListSize;
	static int smsCommandTagList[];					static int smsCommandTagListSize;
private:											
	static int curErr;								
	static SMS_TP_Type	smsTPTable[];				static int smsTPTableSize;
	static SMS_T_Type	smsTypeTable[];				static int smsTypeTableSize;
	// TP Tags										
	static SMS_TPText_Type smsTPTextTable[];		static int smsTPTextTableSize;
	static SMS_TagText_Type	TP_MTI_Text[];			static int TP_MTI_TextSize;			
	static SMS_TagText_Type	TP_MMS_Text[];			static int TP_MMS_TextSize;
	static SMS_TagText_Type	TP_VPF_Text[];			static int TP_VPF_TextSize;
	static SMS_TagText_Type	TP_SRI_Text[];			static int TP_SRI_TextSize;
	static SMS_TagText_Type	TP_SRR_Text[];			static int TP_SRR_TextSize;
	static SMS_TagText_Type	TP_SRQ_Text[];			static int TP_SRQ_TextSize;
	static SMS_TagText_Type	TP_ST_Text[];			static int TP_ST_TextSize;
	static SMS_TagText_Type	TP_RP_Text[];			static int TP_RP_TextSize;
	static SMS_TagText_Type	TP_CT_Text[];			static int TP_CT_TextSize;
	static SMS_TagText_Type	TP_FCS_Text[];			static int TP_FCS_TextSize;
	static SMS_TagText_Type	TP_UDHI_Text[];			static int TP_UDHI_TextSize;
	static SMS_TagText_Type	TP_RD_Text[];			static int TP_RD_TextSize;
	// Extended Params
	static SMS_TPExtText_Type smsTPExtTextTable[];	static int smsTPExtTextTableSize;
	static SMS_TagText_Type	TP_Dir_Text[];			static int TP_Dir_TextSize;
	static SMS_TagText_Type	TP_AF_TON_Text[];		static int TP_AF_TON_TextSize;
	static SMS_TagText_Type	TP_AF_NPI_Text[];		static int TP_AF_NPI_TextSize;
	static SMS_TagText_Type	TP_DCS_CG_Text[];		static int TP_DCS_CG_TextSize;
	static SMS_TagText_Type	TP_DCS_C_Text[];		static int TP_DCS_C_TextSize;
	static SMS_TagText_Type	TP_DCS_MCM_Text[];		static int TP_DCS_MCM_TextSize;
	static SMS_TagText_Type	TP_DCS_MCl_Text[];		static int TP_DCS_MCl_TextSize;
	static SMS_TagText_Type	TP_DCS_MCo_Text[];		static int TP_DCS_MCo_TextSize;
	static SMS_TagText_Type	TP_DCS_A_Text[];		static int TP_DCS_A_TextSize;
	static SMS_TagText_Type	TP_DCS_I_Text[];		static int TP_DCS_I_TextSize;
	static SMS_TagText_Type	TP_DCS_IT_Text[];		static int TP_DCS_IT_TextSize;
	static SMS_TagText_Type	TP_PID_T_Text[];		static int TP_PID_T_TextSize;
	static SMS_TagText_Type	TP_PID_TI_Text[];		static int TP_PID_TI_TextSize;
	static SMS_TagText_Type	TP_PID_TIT_Text[];		static int TP_PID_TIT_TextSize;
	static SMS_TagText_Type	TP_PID_SMT_Text[];		static int TP_PID_SMT_TextSize;
	static SMS_TagText_Type	TP_VP_E_EB_Text[];		static int TP_VP_E_EB_TextSize;
	static SMS_TagText_Type	TP_VP_E_SS_Text[];		static int TP_VP_E_SS_TextSize;
	static SMS_TagText_Type	TP_VP_E_F_Text[];		static int TP_VP_E_F_TextSize;
	static SMS_TagText_Type	TP_PI_PID_Text[];		static int TP_PI_PID_TextSize;
	static SMS_TagText_Type	TP_PI_DCS_Text[];		static int TP_PI_DCS_TextSize;
	static SMS_TagText_Type	TP_PI_UDL_Text[];		static int TP_PI_UDL_TextSize;
	static SMS_TagText_Type	TP_UD_Status_Text[];	static int TP_UD_Status_TextSize;		
	static SMS_TagText_Type	TP_UD_S_Store_Text[];	static int TP_UD_S_Store_TextSize;		
	static SMS_TagText_Type	TP_UD_SMSC_S_Text[];	static int TP_UD_SMSC_S_TextSize;	
	static SMS_TagText_Type	TP_UD_SMSC_SP_Text[];	static int TP_UD_SMSC_SP_TextSize;	
	static SMS_TagText_Type	TP_UD_SMSC_STA_Text[];	static int TP_UD_SMSC_STA_TextSize;
	static SMS_TagText_Type	TP_UD_SMSC_STT_Text[];	static int TP_UD_SMSC_STT_TextSize;
	static SMS_TagText_Type	TP_UD_SMSC_SCo_Text[];	static int TP_UD_SMSC_SCo_TextSize;
	static SMS_TagText_Type	TP_UD_SMSC_SCa_Text[];	static int TP_UD_SMSC_SCa_TextSize;
	static SMS_TagText_Type	TP_UD_SMSC_SI_Text[];	static int TP_UD_SMSC_SI_TextSize;	
	static SMS_TagText_Type	TP_UD_UDH_S_Text[];		static int TP_UD_UDH_S_TextSize;	
private:
	// Encode/Decode Functions
	static Int32 TP_VP  (CSMSCodecParams* ioParams);
	static Int32 TP_CD  (CSMSCodecParams* ioParams);
	static Int32 TP_UD  (CSMSCodecParams* ioParams);
	static Int32 TP_UDL (CSMSCodecParams* ioParams);
	static Int32 TP_MTI (CSMSCodecParams* ioParams);
	static Int32 TP_PI	(CSMSCodecParams* ioParams);
	static Int32 TP_PID (CSMSCodecParams* ioParams);
	static Int32 TP_DCS (CSMSCodecParams* ioParams);
	static Int32 TP_MMS (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_MMS);}
	static Int32 TP_VPF (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_VPF);}
	static Int32 TP_SRI (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_SRx);}
	static Int32 TP_SRR (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_SRx);}
	static Int32 TP_SRQ (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_SRx);}
	static Int32 TP_MR  (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_MR);}
	static Int32 TP_ST  (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_ST);}
	static Int32 TP_RP  (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_RP);}
	static Int32 TP_MN  (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_MN);}
	static Int32 TP_CT  (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_CT);}
	static Int32 TP_CDL (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_xDL);}
	static Int32 TP_FCS (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_FCS);}
	static Int32 TP_UDHI(CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_UDHI);}
	static Int32 TP_RD  (CSMSCodecParams* ioParams) {return PrvExtractParam(ioParams, &ioParams->paramsP->tp_RD);}
	static Int32 TP_OA  (CSMSCodecParams* ioParams)	{return PrvProcessAddressField(ioParams->coding, false, ioParams->pduBufP, ioParams->offset, &ioParams->paramsP->tp_xA);}
	static Int32 TP_DA  (CSMSCodecParams* ioParams)	{return PrvProcessAddressField(ioParams->coding, false, ioParams->pduBufP, ioParams->offset, &ioParams->paramsP->tp_xA);}
	static Int32 TP_RA  (CSMSCodecParams* ioParams)	{return PrvProcessAddressField(ioParams->coding, false, ioParams->pduBufP, ioParams->offset, &ioParams->paramsP->tp_xA);}
	static Int32 TP_SCTS(CSMSCodecParams* ioParams) {return PrvProcessTime(ioParams->coding, ioParams->pduBufP, ioParams->offset, ioParams->paramsP->tp_SCTS);}
	static Int32 TP_DT  (CSMSCodecParams* ioParams)	{return PrvProcessTime(ioParams->coding, ioParams->pduBufP, ioParams->offset, ioParams->paramsP->tp_DT);}
	//
	static Int32 PrvGetSMSTypeFromMTI(int iDirection, Tag iTP_MTI, kSMSType* ioType);
	static Int32 PrvSetSMSTypeToMTI(int iDirection, Tag* ioTP_MTI, kSMSType iType);
	static void	 PrvCalculateUDHL(CSMSCodecParams* ioParams);
	static void	 PrvCalculateUDL(CSMSCodecParams* ioParams);
	static Int32 PrvProcessUserDataHeader(CSMSCodecParams* ioParams);
	static Int32 PrvExtractParam(CSMSCodecParams* ioParams, Tag* ioValue);
	static Int32 PrvProcessTime(Bool iCoding, CString* ioPDUBufP, int iOffSet, Tag* ioParamsP);
	static Int32 PrvProcessAddressField(Bool iCoding, Bool iIsSMSCenter, CString* ioPDUBufP, int iOffSet, CSMSAddressField* ioParamsP);
	static void  PrvSetMultipartHeader(CSMSCodecParams* ioParams);

	static int	 PrvGetCurrentDCS(CSMSCodecParams* iParamsP);
	int			 PrvIsMultipart(CSMSCodecParams* iParamsP);
	int			 PrvGetSMSTPTagIndexFromId(kSMSTPTag iTag);
	
public:
	CSMSCodec(){};
	~CSMSCodec(){};

	int		DecodePDU(Bool iDir, CCharSetString iPDUBufP, CSMSParams* ioParamsP);
	int		EncodePDU(CSMSParams* iParamsP, CSMSPDU* ioPDUListP);
	//
	int		GetSMSTagText(kSMSTPTag iSMSTag, CString* ioTagTextP, int* ioItemsNumber, SMS_TagText_Type** ioItemsTable);
	int		GetSMSTagTextTableLength(void);
	int		GetSMSTagExtText(kSMSTPTagExt iSMSTag, CString* ioTagTextP, int* ioItemsNumber, SMS_TagText_Type **ioItemsTable);
	int		GetSMSTypeTagList(kSMSType iSMSType, int **ioTagListTable);
	int		GetSMSTypeTagListSize(kSMSType iSMSType);
	Int32	GetSMSTypeFromMTI(int iDirection, Tag iTP_MTI, kSMSType* ioType) {return PrvGetSMSTypeFromMTI(iDirection, iTP_MTI, ioType);};
};

#endif	// SMSCODEC_H
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////